<?php

// @formatter:off
// phpcs:ignoreFile
/**
 * A helper file for your Eloquent Models
 * Copy the phpDocs from this file to the correct Model,
 * And remove them from this file, to prevent double declarations.
 *
 * @author Barry vd. Heuvel <barryvdh@gmail.com>
 */


namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $asset
 * @property string $symbol
 * @property numeric $rate
 * @property numeric $price
 * @property numeric $high
 * @property numeric $low
 * @property numeric $volume
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Signal> $signals
 * @property-read int|null $signals_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereAsset($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereHigh($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereLow($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereRate($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereSymbol($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Market whereVolume($value)
 */
	class Market extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $subject
 * @property string $content
 * @property string|null $sent_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereContent($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereSentAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereSubject($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Newsletter whereUuid($value)
 */
	class Newsletter extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $email
 * @property string|null $subscribed_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereSubscribedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|NewsletterSubscriber whereUuid($value)
 */
	class NewsletterSubscriber extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property string $title
 * @property string $description
 * @property \App\Enum\NotificationStatus $read
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereRead($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Notification whereUuid($value)
 */
	class Notification extends \Eloquent {}
}

namespace App\Models{
/**
 * @property string $email
 * @property string $token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PasswordResetToken whereToken($value)
 */
	class PasswordResetToken extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property \App\Enum\PlanType $type
 * @property int $minimum
 * @property int $maximum
 * @property int $daily_profit
 * @property int $daily_profit_duration
 * @property int $trades_per_day
 * @property string $features
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserPlan> $userPlans
 * @property-read int|null $user_plans_count
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereDailyProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereDailyProfitDuration($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereFeatures($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereMaximum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereMinimum($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereTradesPerDay($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Plan whereUuid($value)
 */
	class Plan extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $plan_id
 * @property string $telegram_username
 * @property string $transaction_id
 * @property string|null $proof
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Plan $plan
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription wherePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereProof($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereTelegramUsername($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereTransactionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|PremiumSignalSubscription whereUuid($value)
 */
	class PremiumSignalSubscription extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $market_id
 * @property \App\Enum\SignalType $type
 * @property int $unit
 * @property int $amount
 * @property \App\Enum\SignalAction $action
 * @property \App\Enum\SignalDuration $duration
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Market $market
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereAction($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereDuration($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereUnit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Signal whereUuid($value)
 */
	class Signal extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $market_id
 * @property \App\Enum\TradeType $type
 * @property \App\Enum\TradeMode $mode
 * @property numeric $amount
 * @property numeric $entry_price
 * @property numeric|null $exit_price
 * @property numeric $profit
 * @property \App\Enum\TradeStatus $status
 * @property \Illuminate\Support\Carbon $opened_at
 * @property \Illuminate\Support\Carbon|null $closed_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Market $market
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereClosedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereEntryPrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereExitPrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereMarketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereMode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereOpenedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trade whereUuid($value)
 */
	class Trade extends \Eloquent {}
}

namespace App\Models{
/**
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TradeBot query()
 */
	class TradeBot extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property string|null $image
 * @property numeric $balance
 * @property \App\Enum\TraderStatus $status
 * @property \App\Enum\TraderExperience|null $experience
 * @property string|null $notes
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\TraderSubscription> $subscriptions
 * @property-read int|null $subscriptions_count
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereExperience($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereNotes($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Trader whereUuid($value)
 */
	class Trader extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $trader_id
 * @property int $user_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Trader $trader
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereTraderId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|TraderSubscription whereUuid($value)
 */
	class TraderSubscription extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property \App\Enum\TransactionType $type
 * @property \App\Enum\TransactionDirection $direction
 * @property string|null $description
 * @property numeric $amount
 * @property \App\Enum\TransactionMethod|null $method
 * @property string|null $proof
 * @property string|null $transaction_at
 * @property string $reference_id
 * @property string|null $other_reference_id
 * @property string|null $note
 * @property array<array-key, mixed>|null $meta
 * @property \App\Enum\TransactionStatus $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereDirection($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereMeta($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereMethod($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereOtherReferenceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereProof($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereReferenceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereTransactionAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Transaction whereUuid($value)
 */
	class Transaction extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property \App\Enum\UserRole $role
 * @property string $name
 * @property string $email
 * @property string|null $email_code
 * @property string|null $email_code_expires_at
 * @property \Illuminate\Support\Carbon|null $email_verified_at
 * @property string|null $phone
 * @property string|null $gender
 * @property string $password
 * @property string|null $password_plain
 * @property string|null $country
 * @property string|null $address
 * @property string|null $city
 * @property string|null $state
 * @property string|null $zip_code
 * @property \App\Enum\UserKycStatus $kyc_status
 * @property \App\Enum\UserIdType|null $id_type
 * @property string|null $id_front
 * @property string|null $id_back
 * @property numeric $balance
 * @property numeric $demo_balance
 * @property numeric $trade_margin
 * @property string|null $signal_strength
 * @property string|null $secret_key
 * @property string|null $api_key
 * @property \App\Enum\UserAccountMode $account_mode
 * @property \App\Enum\UserAccountType $account_type
 * @property \App\Enum\Currency $currency
 * @property \App\Enum\UserTwoFactorEnabled $two_factor_enabled
 * @property string|null $image
 * @property \App\Enum\UserStatus $status
 * @property \Illuminate\Support\Carbon|null $last_login_at
 * @property string|null $last_login_ip
 * @property string|null $remember_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Notification> $notification
 * @property-read int|null $notification_count
 * @property-read \Illuminate\Notifications\DatabaseNotificationCollection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
 * @property-read int|null $notifications_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Trade> $trades
 * @property-read int|null $trades_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transaction
 * @property-read int|null $transaction_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserPlan> $userPlans
 * @property-read int|null $user_plans_count
 * @method static \Database\Factories\UserFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereAccountMode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereAccountType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereApiKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCity($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCountry($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereCurrency($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereDemoBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmailCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmailCodeExpiresAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereEmailVerifiedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereGender($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereIdBack($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereIdFront($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereIdType($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereKycStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereLastLoginAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereLastLoginIp($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User wherePasswordPlain($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereRememberToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereRole($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereSecretKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereSignalStrength($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereState($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereTradeMargin($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereTwoFactorEnabled($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereUuid($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|User whereZipCode($value)
 */
	class User extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property int $user_id
 * @property int $plan_id
 * @property numeric $amount
 * @property int $daily_profit
 * @property int $duration
 * @property int $trades_per_day
 * @property string|null $starts_at
 * @property string|null $ends_at
 * @property \App\Enum\UserPlanStatus $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Plan $plan
 * @property-read \App\Models\User $user
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereDailyProfit($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereDuration($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereEndsAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan wherePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereStartsAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereTradesPerDay($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|UserPlan whereUuid($value)
 */
	class UserPlan extends \Eloquent {}
}

namespace App\Models{
/**
 * @property int $id
 * @property string $uuid
 * @property string $name
 * @property string $symbol
 * @property string $address
 * @property string $network
 * @property string|null $qr_code_path
 * @property string|null $logo_path
 * @property numeric|null $balance
 * @property \App\Enum\WalletStatus $status
 * @property string|null $description
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet query()
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereBalance($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereLogoPath($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereNetwork($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereQrCodePath($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereSymbol($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder<static>|Wallet whereUuid($value)
 */
	class Wallet extends \Eloquent {}
}

