<?php

namespace App\Enum;

enum NotificationStatus: int
{
    case Unread = 0;
    case Read = 1;

    public function label(): string
    {
        return match ($this) {
            self::Unread => 'Unread',
            self::Read => 'Read',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::Unread => 'badge bg-danger-subtle text-danger fs-12 p-1',
            self::Read => 'badge bg-success-subtle text-success fs-12 p-1',
        };
    }
}
