<?php

namespace App\Enum;

enum TradeType: string
{
    case BUY = 'buy';
    case SELL = 'sell';

    public function label(): string
    {
        return match ($this) {
            self::BUY => 'Buy',
            self::SELL => 'Sell',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::BUY => 'badge bg-success-subtle text-success fs-12 p-1',
            self::SELL => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
