<?php

namespace App\Enum;

enum TraderExperience: string
{
    case BEGINNER = 'beginner';
    case INTERMEDIATE = 'intermediate';
    case ADVANCED = 'advanced';

    public function label(): string
    {
        return match ($this) {
            self::BEGINNER => 'Beginner',
            self::INTERMEDIATE => 'Intermediate',
            self::ADVANCED => 'Advanced',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::BEGINNER => 'badge bg-success-subtle text-success fs-12 p-1',
            self::INTERMEDIATE => 'badge bg-warning-subtle text-warning fs-12 p-1',
            self::ADVANCED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }
}
