<?php

namespace App\Enum;

enum TraderStatus: string
{
    case ACTIVE = 'active';
    case INACTIVE = 'inactive';
    case SUSPENDED = 'suspended';

    public function label(): string
    {
        return match ($this) {
            self::ACTIVE => 'Active',
            self::INACTIVE => 'Inactive',
            self::SUSPENDED => 'Suspended',
        };
    }

    public function badge(): string
    {
        return match ($this) {
            self::ACTIVE => 'badge bg-success-subtle text-success fs-12 p-1',
            self::INACTIVE => 'badge bg-danger-subtle text-danger fs-12 p-1',
            self::SUSPENDED => 'badge bg-warning-subtle text-warning fs-12 p-1',
        };
    }
}
