<?php

namespace App\Enum;

enum TransactionMethod: string
{
    case CRYPTO = 'crypto';
    case BANK = 'bank';
    case TRADE = 'trade';
    case SWAP = 'swap';
    
    public function label(): string
    {
        return match ($this) {
            self::CRYPTO => 'Crypto',
            self::BANK => 'Bank',
            self::TRADE => 'Trade',
            self::SWAP => 'Swap',
        };
    }
}
