<?php

namespace App\Enum;

enum UserKycStatus: string
{
    case PENDING = 'pending';
    case APPROVED = 'approved';
    case REJECTED = 'rejected';

    public function label()
    {
        return match ($this) {
            self::PENDING => 'Pending',
            self::APPROVED => 'Approved',
            self::REJECTED => 'Rejected',
        };
    }

    public function badge()
    {
        return match ($this) {
            self::PENDING => 'badge bg-warning-subtle text-warning fs-12 p-1',
            self::APPROVED => 'badge bg-success-subtle text-success fs-12 p-1',
            self::REJECTED => 'badge bg-danger-subtle text-danger fs-12 p-1',
        };
    }

    public function textColor()
    {
        return match ($this) {
            self::PENDING => 'text-warning',
            self::APPROVED => 'text-success',
            self::REJECTED => 'text-danger',
        };
    }
}
