<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\User;
use App\Enum\UserRole;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $welcomeMessage = 'Welcome' . ' ' . Auth::user()->name;

        $breadcrumbs = [
            ['label' => config('app.name'), 'url' => '/'],
            ['label' => 'Dashboard', 'url' => route('admin.dashboard')],
            ['label' => $welcomeMessage, 'active' => true]
        ];

        $users = User::where('role', UserRole::USER->value)->latest()->get();

        $data = [
            'title' => $welcomeMessage,
            'users' => $users,
            'breadcrumbs' => $breadcrumbs
        ];

        return view('dashboard.admin.index', $data);
    }
}
