<?php

namespace App\Http\Requests;

use App\Models\Market;
use Illuminate\Foundation\Http\FormRequest;

class UpdateMarketRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {

        $marketUUID = $this->route('market');
        $market = Market::where('uuid', $marketUUID)->firstOrFail();

        return [
            // Market Pair
            'asset' => [
                'required',
                'string',
                'max:50',
                'regex:/^[A-Z0-9]{2,15}\s?\/\s?[A-Z0-9]{2,15}$/',
                'unique:markets,asset,' . $market->id,
            ],

            // Price Metrics
            'rate' => [
                'required',
                'numeric',
                'min:0',
            ],

            'price' => [
                'required',
                'numeric',
                'min:0',
            ],

            'high' => [
                'required',
                'numeric',
                'min:0',
            ],

            'low' => [
                'required',
                'numeric',
                'min:0',
            ],

            // Volume
            'volume' => [
                'required',
                'numeric',
                'min:0',
            ],
        ];
    }
}
