<?php

namespace App\Models;

use App\Enum\PlanType;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type' => PlanType::class
    ];

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (empty($model->uuid)) {
                $model->uuid = (string) Str::uuid();
            }
        });
    }

    public function userPlans()
    {
        return $this->hasMany(UserPlan::class);
    }
}
