<?php

namespace App\Models;

use App\Enum\TradeMode;
use App\Enum\TradeType;
use App\Enum\TradeStatus;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Trade extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type' => TradeType::class,
        'mode' => TradeMode::class,
        'status' => TradeStatus::class,
        'opened_at' => 'datetime',
        'closed_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function market()
    {
        return $this->belongsTo(Market::class);
    }
}
