<?php

namespace App\Models;

use App\Enum\Currency;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class TradeBot extends Model
{
    protected $guarded = [];

    protected $casts = [
        'minimum' => 'decimal:8',
        'maximum' => 'decimal:8',
        'currency' => Currency::class
    ];
    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }
}
