<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class TraderSubscription extends Model
{
    protected $guarded = [];

    protected $casts = [];

    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }

    public function trader()
    {
        return $this->belongsTo(Trader::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
