<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'guestUser' => App\Http\Middleware\GuestUserMiddleware::class,
            'user' => App\Http\Middleware\UserMiddleware::class,
            'admin' => App\Http\Middleware\AdminMiddleware::class,
            'master' => App\Http\Middleware\MasterMiddleware::class,
            'registeredUser' => App\Http\Middleware\RegisteredUserMiddleware::class,
            'kycVerification' => App\Http\Middleware\UserKycVerification::class,
        ]);
    })->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
