<?php

use App\Models\Market;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('signals', function (Blueprint $table) {
            $table->id();

            // Public identifier (safe for APIs)
            $table->uuid('uuid')->unique();

            // Market this signal belongs to
            $table->foreignIdFor(\App\Models\Market::class)
                ->constrained()
                ->cascadeOnDelete();

            // Signal category (e.g. scalp, intraday, swing)
            $table->string('type', 30);

            // Quantity / units involved in the signal
            $table->unsignedInteger('unit');

            // Monetary or asset amount (never negative)
            $table->unsignedInteger('amount');

            // Trade direction (buy / sell)
            $table->string('action', 10);

            // Duration in minutes (enum-backed in code)
            $table->unsignedSmallInteger('duration');

            $table->timestamps();

            // Performance / query indexes
            $table->index('type');
            $table->index('action');
            $table->index('duration');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('signals');
    }
};
