<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Starter Plan',
                'type' => 'basic',
                'minimum' => 100,
                'maximum' => 1000,
                'daily_profit' => 2,
                'daily_profit_duration' => 30,
                'trades_per_day' => 3,
                'features' => "
                    24/7 Support,
                    Access to basic signals,
                    Low risk trades",
            ],
            [
                'name' => 'Pro Plan',
                'type' => 'premium',
                'minimum' => 1000,
                'maximum' => 10000,
                'daily_profit' => 5,
                'daily_profit_duration' => 30,
                'trades_per_day' => 5,
                'features' => "
                    Priority Support,
                    Access to all signals,
                    Medium risk trades,
                    Weekly reports",
            ],
            [
                'name' => 'Elite Plan',
                'type' => 'basic',
                'minimum' => 10000,
                'maximum' => 100000,
                'daily_profit' => 10,
                'daily_profit_duration' => 30,
                'trades_per_day' => 10,
                'features' => "
                    Dedicated account manager,
                    Access to exclusive signals,
                    High risk trades with high reward,
                    Daily reports",
            ],
        ];

        foreach ($plans as $plan) {
            Plan::create(array_merge($plan, [
                'uuid' => Str::uuid(),
            ]));
        }
    }
}
