<?php

namespace Database\Seeders;

use App\Models\Market;
use App\Models\Signal;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class SignalSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get some existing markets
        $markets = Market::all();

        if ($markets->isEmpty()) {
            $this->command->info('No markets found. Please seed markets first.');
            return;
        }

        $signals = [
            [
                'type' => 'live',
                'unit' => 10,
                'amount' => 500,
                'action' => 'buy',
                'duration' => 5, // in minutes
            ],
            [
                'type' => 'demo',
                'unit' => 5,
                'amount' => 1000,
                'action' => 'sell',
                'duration' => 10,
            ],
            [
                'type' => 'demo',
                'unit' => 2,
                'amount' => 2000,
                'action' => 'buy',
                'duration' => 30,
            ],
        ];

        foreach ($signals as $signalData) {
            // Pick a random market for this signal
            $market = $markets->random();

            Signal::create(array_merge($signalData, [
                'uuid' => Str::uuid(),
                'market_id' => $market->id,
            ]));
        }
    }
}
