<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8" />
        <title>{{ $title }} &mdash; {{ config('app.name') }}</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="{{ config('app.meta.keywords') }}" name="keywords">
        <meta content="{{ config('app.meta.description') }}" name="description">
        <meta property="og:title" content="{{ config('app.name') }} - {{ config('app.slogan') }}" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="{{ url()->current() }}" />
        <meta property="og:image" content="{{ asset(config('app.assets.og_image')) }}" />

        <!-- App favicon -->
        <link rel="shortcut icon" href="{{ asset(config('app.assets.favicon')) }}">

        <!-- Theme Config Js -->
        <script src="/dashboard/assets/js/config.js"></script>

        <!-- Vendor css -->
        <link href="/dashboard/assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

        <!-- App css -->
        <link href="/dashboard/assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

        <!-- Icons css -->
        <link href="/dashboard/assets/css/icons.min.css" rel="stylesheet" type="text/css" />

        @include('partials.google_translator')

        <script src="/assets/js/sweet_alert2.js"></script>

        @livewireStyles
    </head>

    <body>

        @yield('content')

        <!-- Vendor js -->
        <script src="/dashboard/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="/dashboard/assets/js/app.js"></script>

        @livewireScripts

        @include('partials.live_chat')
    </body>

</html>
