<div class="table-responsive">
    <table class="table table-bordered align-middle">
        <tbody>
            <tr>
                <th scope="row" class="w-25">Transaction ID</th>
                <td>{{ $transaction->uuid }}</td>
            </tr>
            <tr>
                <th scope="row" class="w-25">Transaction Reference</th>
                <td>{{ $transaction->reference_id }}</td>
            </tr>

            <tr>
                <th>Type</th>
                <td>{{ $transaction->type->label() }}</td>
            </tr>

            <tr>
                <th>Amount</th>
                <td><strong>{{ currency($transaction->user->currency) }}{{ formatAmount($transaction->amount) }}</strong>
                </td>
            </tr>

            <tr>
                <th>Payment Method</th>
                <td>{{ $transaction->deposit_method }}</td>
            </tr>

            <tr>
                <th>Status</th>
                <td>
                    <span class="{{ $transaction->status->badge() }}">
                        {{ $transaction->status->label() }}
                    </span>
                </td>
            </tr>

            <tr>
                <th>Transaction Date</th>
                <td>{{ formatDateTime($transaction->transaction_at) }}</td>
            </tr>

            <tr>
                <th>Description</th>
                <td>{{ $transaction->description ?? 'N/A' }}</td>
            </tr>

            @if ($transaction->note)
                <tr>
                    <th>Note</th>
                    <td>{{ $transaction->note }}</td>
                </tr>
            @endif

            @if ($transaction->proof)
                <tr>
                    <th>Proof of Payment</th>
                    <td>
                        <a href="{{ asset($transaction->proof) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="ti ti-file"></i> View Proof
                        </a>
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
</div>
