@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.plan.create'),
                'text' => 'Add New Plan',
                'icon' => 'fa fa-plus me-1',
            ]">

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Type</th>
                                <th>Features</th>
                                <th>Trades Per Day</th>
                                <th>Minimum</th>
                                <th>Maximum</th>
                                <th>Daily Profit</th>
                                <th>Duration</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($plans as $plan)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $plan->name }}</td>
                                    <td>{{ $plan->type->label() }}</td>
                                    <td>{{ $plan->features }}</td>
                                    <td>{{ $plan->trades_per_day }}</td>
                                    <td>{{ formatAMount($plan->minimum, 0) }}</td>
                                    <td>{{ formatAmount($plan->maximum, 0) }}</td>
                                    <td>{{ $plan->daily_profit }}</td>
                                    <td>{{ $plan->daily_profit_duration }}</td>
                                    <td>
                                        <a href="{{ route('admin.plan.show', $plan->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>

                                        <a href="{{ route('admin.plan.edit', $plan->uuid) }}"
                                            class="btn btn-primary btn-sm m-1">
                                            <i class="fa fa-edit me-1"></i> Edit
                                        </a>

                                        <form action="{{ route('admin.plan.delete', $plan->uuid) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this plan?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @foreach ($plans as $plan)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title"><strong>Name:</strong>
                                    {{ $plan->name }}
                                </h5>

                                <p class="mb-1"><strong>Type:</strong> {{ $plan->type->label() }}</p>
                                <p class="mb-1"><strong>Features:</strong> {{ $plan->features }}</p>
                                <p class="mb-1"><strong>Trades / Day:</strong> {{ $plan->trades_per_day }}</p>
                                <p class="mb-1"><strong>Minimum:</strong> {{ formatAmount($plan->minimum, 0) }}</p>
                                <p class="mb-1"><strong>Maximum:</strong> {{ formatAmount($plan->maximum, 0) }}</p>
                                <p class="mb-1"><strong>Daily Profit:</strong> {{ $plan->daily_profit }}</p>
                                <p class="mb-2"><strong>Duration:</strong> {{ $plan->daily_profit_duration }}</p>

                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.plan.show', $plan->uuid) }}" class="btn btn-info btn-sm m-1">
                                        <i class="fa fa-file-text me-1"></i> View
                                    </a>

                                    <a href="{{ route('admin.plan.edit', $plan->uuid) }}"
                                        class="btn btn-primary btn-sm m-1">
                                        <i class="fa fa-edit me-1"></i> Edit
                                    </a>

                                    <form action="{{ route('admin.plan.delete', $plan->uuid) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm m-1"
                                            onclick="return confirm('Are you sure you want to delete this plan?')">
                                            <i class="fa fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
