@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.signal.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.signal.update', $signal->uuid) }}" method="post">
                    @csrf
                    @method('PATCH')

                    <div class="row">

                        <div class="col-md-12 mb-3">
                            <label for="market_id" class="form-label fw-semibold">Select Asset</label>
                            <select name="market_id" id="market_id"
                                class="form-select @error('market_id') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($markets as $market)
                                    <option value="{{ $market->id }}"
                                        {{ old('market_id', $signal->market_id) == $market->id ? 'selected' : '' }}>
                                        {{ $market->asset }}</option>
                                @endforeach
                            </select>
                            @error('market_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="duration" class="form-label fw-semibold">Select Duration</label>
                            <select name="duration" id="duration"
                                class="form-select @error('duration') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($signalDurations as $signalDuration)
                                    <option value="{{ $signalDuration->value }}"
                                        {{ old('duration', $signal->duration->value) == $signalDuration->value ? 'selected' : '' }}>
                                        {{ $signalDuration->label() }}</option>
                                @endforeach
                            </select>
                            @error('duration')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="type" class="form-label fw-semibold">Select Type</label>
                            <select name="type" id="type" class="form-select @error('type') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($signalTypes as $signalType)
                                    <option value="{{ $signalType->value }}"
                                        {{ old('type', $signal->type->value) == $signalType->value ? 'selected' : '' }}>
                                        {{ $signalType->label() }}</option>
                                @endforeach
                            </select>
                            @error('type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12 mb-3">
                            <label for="action" class="form-label fw-semibold">Select Action</label>
                            <select name="action" id="action" class="form-select @error('action') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($signalActions as $signalAction)
                                    <option value="{{ $signalAction->value }}"
                                        {{ old('action', $signal->action->value) == $signalAction->value ? 'selected' : '' }}>
                                        {{ $signalAction->label() }}</option>
                                @endforeach
                            </select>
                            @error('action')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <x-dashboard.form-input name="amount" label="Amount" class="col-md-6 mb-3"
                            value="{{ old('amount', $signal->amount) }}" type="number" placeholder="500" required />

                        <x-dashboard.form-input name="unit" label="Unit(1-100)" class="col-md-6 mb-3"
                            value="{{ old('unit', $signal->unit) }}" type="number" placeholder="120" required />

                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
