@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trader.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">

                    <dt class="col-sm-3">UUID</dt>
                    <dd class="col-sm-9">{{ $trader->uuid }}</dd>

                    <dt class="col-sm-3">Name</dt>
                    <dd class="col-sm-9">{{ $trader->user->name }}</dd>

                    @if ($trader->image)
                        <dt class="col-sm-3">Image</dt>
                        <dd class="col-sm-9">
                            <img src="{{ asset($trader->image) }}" width="200" class="img-thumbnail"
                                alt="{{ $trader->user->name }}">
                        </dd>
                    @endif

                    <dt class="col-sm-3">Balance</dt>
                    <dd class="col-sm-9">{{ currency($trader->user->currency) . formatAmount($trader->balance) }}</dd>

                    <dt class="col-sm-3">Status</dt>
                    <dd class="col-sm-9">
                        <span class="{{ $trader->status->badge() }}">{{ $trader->status->label() }}</span>
                    </dd>

                    <dt class="col-sm-3">Experience</dt>
                    <dd class="col-sm-9">
                        {{ $trader->experience->label() }}
                    </dd>

                    @if ($trader->notes)
                        <dt class="col-sm-3">Notes</dt>
                        <dd class="col-sm-9">
                            {{ $trader->notes }}
                        </dd>
                    @endif
                </dl>

                <div class="d-flex gap-2">
                    <a href="{{ route('admin.trader.show', $trader->uuid) }}" class="btn btn-info btn-sm m-1">
                        <i class="fa fa-file-text me-1"></i> View
                    </a>

                    <a href="{{ route('admin.trader.edit', $trader->uuid) }}" class="btn btn-primary btn-sm m-1">
                        <i class="fa fa-edit me-1"></i> Edit
                    </a>

                    <a href="{{ route('admin.trader.subscription.index', $trader->uuid) }}"
                        class="btn btn-warning btn-sm m-1">
                        <i class="fa fa-file-text me-1"></i> View Subscriptions
                    </a>

                    <form action="{{ route('admin.trader.delete', $trader->uuid) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm m-1"
                            onclick="return confirm('Are you sure you want to delete this trader?')">
                            <i class="fa fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
