 @extends('dashboard.admin.layouts.app')
 @section('content')
     <div class="page-container">

         <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
             <div class="flex-grow-1">
                 <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
             </div>

             <div class="text-end">
                 <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
             </div>
         </div>

         <div class="row">
             <x-dashboard.card title="{{ $title }}" :button="[
                 'route' => route('admin.trader.show', $trader->uuid),
                 'text' => 'Back to Trader Details',
                 'icon' => 'fa fa-arrow-left me-1',
             ]">

                 <div class="table-responsive d-none d-md-block">
                     <table id="myTable" class="table table-bordered table-striped">
                         <thead>
                             <tr>
                                 <th>#</th>
                                 <th>Subscription ID</th>
                                 <th>User</th>
                                 <th>Trader</th>
                                 <th>Trader Status</th>
                                 <th>Trader Experience</th>
                                 <th>Subscribed At</th>
                             </tr>
                         </thead>
                         <tbody>
                             @foreach ($traderSubscriptions as $traderSubscription)
                                 <tr>
                                     <td>{{ $loop->iteration }}</td>

                                     <td>
                                         {{ $traderSubscription->uuid }}
                                     </td>

                                     <td>
                                         <a
                                             href="{{ route('admin.user.show', $traderSubscription->user->uuid) }}">{{ $traderSubscription->user->name }}</a>
                                     </td>

                                     <td>
                                         <a
                                             href="{{ route('admin.user.show', $traderSubscription->trader->user->uuid) }}">{{ $traderSubscription->trader->user->name }}</a>
                                     </td>

                                     <td>
                                         <span class="{{ $traderSubscription->trader->status->badge() }}">
                                             {{ $traderSubscription->trader->status->label() }}</span>
                                     </td>

                                     <td>{{ $traderSubscription->trader->experience->label() }}:
                                         {{ $traderSubscription->trader->notes }}</td>

                                     <td>
                                         {{ formatDateTime($traderSubscription->created_at) }}
                                     </td>
                                 </tr>
                             @endforeach
                         </tbody>
                     </table>
                 </div>

                 <div class="d-block d-md-none">
                     @foreach ($traderSubscriptions as $traderSubscription)
                         <div class="card mb-3 shadow-sm">
                             <div class="card-body">

                                 <h5 class="card-title">
                                     <strong> Subscription ID:</strong>
                                     {{ $traderSubscription->uuid }}
                                 </h5>

                                 <p class="mb-1"><strong>User:</strong>
                                     <a
                                         href="{{ route('admin.user.show', $traderSubscription->user->uuid) }}">{{ $traderSubscription->user->name }}</a>
                                 </p>

                                 <p class="mb-1"><strong>Trader:</strong>
                                     <a
                                         href="{{ route('admin.user.show', $traderSubscription->trader->user->uuid) }}">{{ $traderSubscription->trader->user->name }}</a>
                                 </p>

                                 <p class="mb-1"><strong>Trader Status:</strong>
                                     <span class="{{ $traderSubscription->trader->status->badge() }}">
                                         {{ $traderSubscription->trader->status->label() }}</span>
                                 </p>

                                 <p class="mb-1"><strong>Trader Experience:</strong>
                                     {{ $traderSubscription->trader->experience->label() }}:
                                     {{ $traderSubscription->trader->notes }}
                                 </p>

                                 <p class="mb-1"><strong>Subscribed At:</strong>
                                     {{ formatDateTime($traderSubscription->created_at) }}
                                 </p>

                             </div>
                         </div>
                     @endforeach
                 </div>

             </x-dashboard.card>
         </div>

     </div>
 @endsection
