@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('admin.user.notification.create', $user->uuid),
                    'text' => 'New Notification',
                    'icon' => 'fa fa-plus me-1',
                ]">

                    <div class="table-responsive d-none d-md-block">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Message</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($notifications as $notification)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>
                                            {{ $notification->title }}
                                        </td>
                                        <td>{{ $notification->description }}
                                        </td>
                                        <td>
                                            <span class="{{ $notification->read->badge() }}">
                                                {{ $notification->read->label() }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.user.notification.show', [$user->uuid, $notification->uuid]) }}"
                                                class="btn btn-info btn-sm m-1"> <i class="fa fa-file-text me-1"></i>
                                                View</a>

                                            <form
                                                action="{{ route('admin.user.notification.delete', [$user->uuid, $notification->uuid]) }}"
                                                onclick="return confirm('Are you sure you want to delete this notification?')"
                                                method="post">
                                                @csrf
                                                @method('DELETE')

                                                <button type="submit" class="btn btn-danger btn-sm m-1"> <i
                                                        class="ti ti-trash me-1"></i> Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-block d-md-none">
                        @foreach ($notifications as $notification)
                            <div class="card mb-3 shadow-sm">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <strong> Title:</strong>
                                        {{ $notification->title }}
                                    </h5>

                                    <p class="mb-1"><strong>Message:</strong>
                                        {{ $notification->description }}
                                    </p>
                                    <p class="mb-2"><strong>Status:</strong>
                                        <span class="{{ $notification->read->badge() }}">
                                            {{ $notification->read->label() }}
                                        </span>
                                    </p>

                                    <div class="d-flex gap-2">
                                        <a href="{{ route('admin.user.notification.show', [$user->uuid, $notification->uuid]) }}"
                                            class="btn btn-info btn-sm m-1"> <i class="fa fa-file-text me-1"></i>
                                            View</a>

                                        <form
                                            action="{{ route('admin.user.notification.delete', [$user->uuid, $notification->uuid]) }}"
                                            onclick="return confirm('Are you sure you want to delete this notification?')"
                                            method="post">
                                            @csrf
                                            @method('DELETE')

                                            <button type="submit" class="btn btn-danger btn-sm m-1"> <i
                                                    class="ti ti-trash me-1"></i> Delete</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <x-slot name="footer">
                        <form action="{{ route('admin.user.notification.delete_all', $user->uuid) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button onclick="return confirm('Are you sure you want to delete all notifications?')"
                                type="submit" class="btn btn-danger btn-sm m-1">
                                <i class="ti ti-trash me-1"></i> Delete All
                            </button>
                        </form>
                    </x-slot>

                </x-dashboard.card>
            </div>
        </div>

    </div>
@endsection
