@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.card title="{{ $title }}">

                    <div class="table-responsive d-none d-md-block">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Plan</th>
                                    <th>Amount</th>
                                    <th>Daily Profit</th>
                                    <th>Duration</th>
                                    <th>Trades Per Day</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($userPlans as $userPlan)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td><a
                                                href="{{ route('admin.plan.show', $userPlan->plan->uuid) }}">{{ $userPlan->plan->name }}</a>
                                        </td>
                                        <td>{{ currency($user->currency) . formatAmount($userPlan->amount) }}</td>
                                        <td>{{ currency($user->currency) . formatAmount($userPlan->daily_profit) }}</td>
                                        <td>{{ $userPlan->duration }}</td>
                                        <td>{{ $userPlan->trades_per_day }}</td>
                                        <td>
                                            <span
                                                class="{{ $userPlan->status->badge() }}">{{ $userPlan->status->label() }}</span>
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.user.plan.show', [$user->uuid, $userPlan->uuid]) }}"
                                                class="btn btn-info btn-sm m-1"> <i class="fa fa-file-text me-1"></i>
                                                View</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-block d-md-none">
                        @foreach ($userPlans as $userPlan)
                            <div class="card mb-3 shadow-sm">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <strong> Plan:</strong>
                                        <a
                                            href="{{ route('admin.plan.show', $userPlan->plan->uuid) }}">{{ $userPlan->plan->name }}</a>
                                    </h5>

                                    <p class="mb-1"><strong>Amount:</strong>
                                        {{ currency($user->currency) . formatAmount($userPlan->amount) }}
                                    </p>
                                    <p class="mb-1"><strong>Daily Profit:</strong>
                                        {{ currency($user->currency) . formatAmount($userPlan->daily_profit) }}
                                    </p>
                                    <p class="mb-1"><strong>Duration:</strong>
                                        {{ $userPlan->duration }}
                                    </p>
                                    <p class="mb-2"><strong>Trades Per Day:</strong>
                                        {{ $userPlan->trades_per_day }}
                                    </p>
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('admin.user.plan.show', [$user->uuid, $userPlan->uuid]) }}"
                                            class="btn btn-info btn-sm m-1"> <i class="fa fa-file-text me-1"></i>
                                            View</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                </x-dashboard.card>
            </div>
        </div>
        <!-- end col -->
    </div>
    <!-- end row -->

    </div>
@endsection
