@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <x-dashboard.card title="{{ $title }}" :button="[
                'text' => 'Back',
                'route' => route('admin.user.plan.index', $user->uuid),
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">
                    <dt class="col-sm-3">Plan</dt>
                    <dd class="col-sm-9">
                        <a href="{{ route('admin.plan.show', $userPlan->plan->uuid) }}">{{ $userPlan->plan->name }}</a>
                    </dd>
                    <dt class="col-sm-3">Amount</dt>
                    <dd class="col-sm-9">
                        {{ currency($user->currency) . formatAmount($userPlan->amount) }}
                    </dd>
                    <dt class="col-sm-3">Daily Profit</dt>
                    <dd class="col-sm-9">
                        {{ currency($user->currency) . formatAmount($userPlan->daily_profit) }}
                    </dd>
                    <dt class="col-sm-3">Duration</dt>
                    <dd class="col-sm-9">
                        {{ $userPlan->duration }}
                    </dd>
                    <dt class="col-sm-3">Trades per Day</dt>
                    <dd class="col-sm-9">
                        {{ $userPlan->trades_per_day }}
                    </dd>
                    @if ($userPlan->starts_at)
                        <dt class="col-sm-3">Starts At</dt>
                        <dd class="col-sm-9">
                            {{ formatDateTime($userPlan->starts_at) }}
                        </dd>
                    @endif
                    @if ($userPlan->ends_at)
                        <dt class="col-sm-3">Ends At</dt>
                        <dd class="col-sm-9">
                            {{ formatDateTime($userPlan->ends_at) }}
                        </dd>
                    @endif
                    <dt class="col-sm-3">Transaction Hash / ID</dt>
                    <dd class="col-sm-9">
                        {{ $transaction->meta['plan']['transaction_hash'] }}
                    </dd>
                    <dt class="col-sm-3">Payment Proof</dt>
                    <dd class="col-sm-9">
                        <a href="{{ asset($transaction->proof) }}"><img src="{{ asset($transaction->proof) }}"
                                alt="{{ $userPlan->plan->name }}" width="200" class="img-thumbnail"></a>
                    </dd>
                    <dt class="col-sm-3">Status</dt>
                    <dd class="col-sm-9">
                        <span class="{{ $userPlan->status->badge() }}">{{ $userPlan->status->label() }}</span>
                    </dd>

                </dl>

            </x-dashboard.card>

            <x-dashboard.card>

                <form action="{{ route('admin.user.plan.update', [$user->uuid, $userPlan->uuid]) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <div class="form-group">
                                <label for="example-select" class="form-label">Status:</label>
                                <select name="status" id="example-select" class="form-select">
                                    @foreach ($userPlanStatues as $status)
                                        <option value="{{ $status->value }}" @selected($status->value === $userPlan->status->value)>
                                            {{ $status->label() }}</option>
                                    @endforeach

                                </select>
                            </div>
                        </div>

                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>

        </div>

    </div>
@endsection
