@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <x-dashboard.card title="Create Transaction">

                <form action="{{ route('admin.user.transaction.store', $user->uuid) }}" method="POST">
                    @csrf
                    <div class="row">
                        <!-- Amount -->
                        <div class="col-md-6 mb-3">
                            <label for="amount" class="form-label">Amount</label>
                            <input type="number" step="0.01" min="0"
                                class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount"
                                value="{{ old('amount', 100000) }}">
                            @error('amount')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Type -->
                        <div class="col-md-6 mb-3">
                            <label for="type" class="form-label">Transaction Type</label>
                            <select id="type" name="type" class="form-select @error('type') is-invalid @enderror">
                                <option value="">-- Select Type --</option>
                                @foreach ($transactionTypes as $transactionType)
                                    <option value="{{ $transactionType->value }}"
                                        {{ old('type', 'deposit') == $transactionType->value ? 'selected' : '' }}>
                                        {{ $transactionType->label() }}</option>
                                @endforeach
                            </select>
                            @error('type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Direction -->
                        <div class="col-md-6 mb-3">
                            <label for="direction" class="form-label">Transaction Direction</label>
                            <select id="direction" name="direction"
                                class="form-select @error('direction') is-invalid @enderror">
                                <option value="">-- Select Direction --</option>
                                @foreach ($transactionDirections as $transactionDirection)
                                    <option value="{{ $transactionDirection->value }}"
                                        {{ old('direction', 'credit') == $transactionDirection->value ? 'selected' : '' }}>
                                        {{ $transactionDirection->name }}</option>
                                @endforeach
                            </select>
                            @error('direction')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Date -->
                        <div class="col-md-6 mb-3">
                            <label for="transaction_at" class="form-label">Transaction Date</label>
                            <input type="datetime-local" class="form-control @error('transaction_at') is-invalid @enderror"
                                id="transaction_at" name="transaction_at"
                                value="{{ old('transaction_at', now()->format('Y-m-d H:i:s')) }}">
                            @error('transaction_at')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Description -->
                        <div class="col-md-6 mb-3">
                            <label for="description" class="form-label">Description</label>
                            <input type="text" class="form-control @error('description') is-invalid @enderror"
                                id="description" name="description" value="{{ old('description') }}"
                                placeholder="Optional">
                            @error('description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Notification -->
                        <div class="col-md-6 mb-3">
                            <label for="notification" class="form-label">Send Notification</label>
                            <select id="notification" name="notification"
                                class="form-select @error('notification') is-invalid @enderror">
                                <option value="none" {{ old('notification') == 'none' ? 'selected' : '' }}>
                                    None
                                </option>
                                <option value="email" {{ old('notification', 'email') == 'email' ? 'selected' : '' }}>
                                    Email
                                </option>
                            </select>
                            @error('notification')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <x-dashboard.form-button />
                </form>

            </x-dashboard.card>

            <x-dashboard.card title="{{ $title }}">

                <x-dashboard.transactions :transactions="$transactions" :user="$user" />

            </x-dashboard.card>

        </div>

    </div>
@endsection
