@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.wallet.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">
                    <dt class="col-sm-3">Name</dt>
                    <dd class="col-sm-9">{{ $wallet->name }}</dd>

                    <dt class="col-sm-3">Symbol</dt>
                    <dd class="col-sm-9">{{ $wallet->symbol }}</dd>

                    <dt class="col-sm-3">Address</dt>
                    <dd class="col-sm-9">{{ $wallet->address }}</dd>

                    <dt class="col-sm-3">Network</dt>
                    <dd class="col-sm-9">{{ $wallet->network }}</dd>

                    <dt class="col-sm-3">QR Code</dt>
                    <dd class="col-sm-9">
                        @if ($wallet->qr_code_path)
                            <img src="{{ asset($wallet->qr_code_path) }}" alt="Payment QR Code" class="img-fluid rounded"
                                style="max-width: 11rem;">
                        @else
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data={{ $wallet->address }}"
                                alt="Payment QR Code" class="img-fluid rounded" style="max-width: 11rem;">
                        @endif
                    </dd>

                    <dt class="col-sm-3">Logo</dt>
                    <dd class="col-sm-9">
                        <img src="{{ asset($wallet->logo_path) }}" width="48" alt="{{ $wallet->name }}"
                            class="img-thumbnail">
                    </dd>

                    @if ($wallet->balance)
                        <dt class="col-sm-3">Balance</dt>
                        <dd class="col-sm-9">{{ formatAmount($wallet->balance) }}{{ $wallet->symbol }}</dd>
                    @endif

                    <dt class="col-sm-3">Status</dt>
                    <dd class="col-sm-9">
                        <span class="{{ $wallet->status->badge() }}">
                            {{ $wallet->status->label() }}
                        </span>
                    </dd>

                    @if ($wallet->description)
                        <dt class="col-sm-3">Description</dt>
                        <dd class="col-sm-9">{{ $wallet->description ?? 'N/A' }}</dd>
                    @endif

                    <dt class="col-sm-3">Created At:</dt>
                    <dd class="col-sm-9">{{ $wallet->created_at->diffForHumans() }}</dd>

                    <dt class="col-sm-3">Updated At:</dt>
                    <dd class="col-sm-9">{{ $wallet->updated_at->diffForHumans() }}</dd>
                </dl>

                <div class="d-flex gap-2">
                    <a href="{{ route('admin.wallet.show', $wallet->uuid) }}" class="btn btn-info btn-sm m-1">
                        <i class="fa fa-file-text me-1"></i> View
                    </a>

                    <a href="{{ route('admin.wallet.edit', $wallet->uuid) }}" class="btn btn-primary btn-sm m-1">
                        <i class="fa fa-edit me-1"></i> Edit
                    </a>

                    <form action="{{ route('admin.wallet.delete', $wallet->uuid) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm m-1"
                            onclick="return confirm('Are you sure you want to delete this wallet?')">
                            <i class="fa fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
