@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12 mt-4">

                @if (!$traderSubscription)
                    <!-- No Subscribed Trader -->
                    <div class="card shadow-sm">
                        <div class="card-body text-center py-5">
                            <i class="ti ti-user-off fs-1 text-muted mb-3 d-block"></i>
                            <h5 class="fw-semibold">No Active Trader Linked</h5>
                            <p class="text-muted mb-4">
                                You are not currently linked to any trader for copy trading.
                            </p>
                            <a href="{{ route('user.copy.trade.index') }}" class="btn btn-primary">
                                Find a Trader
                            </a>
                        </div>
                    </div>
                @else
                    <!-- Subscribed Trader Card -->
                    <div class="card shadow-sm">
                        <div class="card-body">

                            <div class="d-flex align-items-center mb-4">
                                <a href="{{ asset($traderSubscription->trader->image) }}" target="_blank">
                                    <img src="{{ asset($traderSubscription->trader->image) }}"
                                        alt="{{ $traderSubscription->trader->user->name }}" class="rounded-circle me-3"
                                        width="70" height="70">
                                </a>

                                <div>
                                    <h5 class="mb-0 fw-semibold">
                                        {{ $traderSubscription->trader->user->name }}
                                    </h5>
                                    <small class="text-muted">
                                        UUID: {{ $traderSubscription->trader->uuid }}
                                    </small>
                                </div>
                            </div>

                            <!-- Stats -->
                            <div class="row text-center mb-4">
                                <div class="col-md-4">
                                    <div class="border rounded p-3 h-100">
                                        <small class="text-muted d-block">Balance</small>
                                        <span class="fw-semibold">
                                            {{ currency($traderSubscription->trader->user->currency) . formatAmount($traderSubscription->trader->balance) }}
                                        </span>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="border rounded p-3 h-100">
                                        <small class="text-muted d-block">Status</small>
                                        <span class="{{ $traderSubscription->trader->status->badge() }}">
                                            {{ $traderSubscription->trader->status->label() }}
                                        </span>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="border rounded p-3 h-100">
                                        <small class="text-muted d-block">Experience</small>
                                        <span class="fw-semibold">
                                            {{ $traderSubscription->trader->experience->label() }}:
                                            {{ $traderSubscription->trader->notes }}
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Subscription Info -->
                            <div class="border rounded p-3 mb-4">
                                <div class="row">
                                    <div class="col-md-6">
                                        <small class="text-muted d-block">Linked On</small>
                                        <span class="fw-medium">
                                            {{ formatDateTime($traderSubscription->created_at) }}
                                        </span>
                                    </div>

                                    {{-- <div class="col-md-6 text-md-end">
                                        <small class="text-muted d-block">Copy Mode</small>
                                        <span class="fw-medium text-capitalize">
                                            {{ $traderSubscription->mode }}
                                        </span>
                                    </div> --}}
                                </div>
                            </div>

                            <!-- Actions -->
                            <div class="d-flex justify-content-end gap-2">
                                {{-- <a href="#" class="btn btn-outline-primary">
                                    View Performance
                                </a> --}}

                                <form action="{{ route('user.copy.trade.unlink', $traderSubscription->uuid) }}"
                                    method="POST" onsubmit="return confirm('Stop copying this trader?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-outline-danger">
                                        Unlink Trader
                                    </button>
                                </form>
                            </div>

                        </div>
                    </div>
                @endif

            </div>
        </div>

    </div>
@endsection
