@extends('dashboard.user.layouts.app')
@section('content')
    @include('dashboard.user.partials.portfolio_style')

    @include('dashboard.user.partials.signal_style')

    @include('dashboard.user.partials.toggle_balance_style')

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <!-- Trading View -->
            <div class="col-lg-12 mb-4">
                <!-- TradingView Widget BEGIN -->
                <div class="tradingview-widget-container">
                    <div class="tradingview-widget-container__widget"></div>
                    <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow"
                            target="_blank"></a></div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
                        {
                            "symbols": [{
                                    "proName": "FOREXCOM:SPXUSD",
                                    "title": "S&P 500 Index"
                                },
                                {
                                    "proName": "FOREXCOM:NSXUSD",
                                    "title": "US 100 Cash CFD"
                                },
                                {
                                    "proName": "FX_IDC:EURUSD",
                                    "title": "EUR to USD"
                                },
                                {
                                    "proName": "BITSTAMP:BTCUSD",
                                    "title": "Bitcoin"
                                },
                                {
                                    "proName": "BITSTAMP:ETHUSD",
                                    "title": "Ethereum"
                                }
                            ],
                            "colorTheme": "dark",
                            "locale": "en",
                            "largeChartUrl": "",
                            "isTransparent": false,
                            "showSymbolLogo": true,
                            "displayMode": "adaptive"
                        }
                    </script>
                </div>
                <!-- TradingView Widget END -->
            </div>
            <!-- Trading View End -->

            <!-- Kyc Verification -->
            @if (!$user->kycApproved())
                <section class="col-lg-12 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="row align-items-center">

                                <div class="col-xl-2 d-none d-xl-flex justify-content-center">
                                    <img src="{{ asset('assets/images/Privacy-and-encryption-details.svg') }}"
                                        class="img-fluid" alt="Security Illustration">
                                </div>

                                <div class="col-xl-10">
                                    <div class="border-start ps-3">
                                        <h4 class="mb-2">Verify Your Account</h4>
                                        <p class="text-muted">
                                            All KYC information is securely processed in compliance
                                            with applicable data protection regulations.
                                        </p>

                                        <a href="{{ route('user.profile.kyc') }}" class="btn btn-primary mt-2">
                                            Get Started
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </section>
            @endif
            <!-- Kyc Verification End -->

            <!-- Portfolio -->
            <section class="col-lg-8 mb-4">
                <div class="card portfolio-card">
                    <div class="card-body">

                        <!-- Header -->
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="mb-0">Portfolio Overview</h5>
                            <span class="{{ $user->status->badge() }}">
                                {{ $user->status->label() }}
                            </span>
                        </div>

                        <!-- Balance -->
                        <div class="portfolio-balance mb-4">
                            <span class="label">Total Equity</span>
                            <div class="amount">
                                <span class="balance-value">
                                    {{ currency($user->currency) . formatAmount($user->balance, 2) }}
                                </span>
                                <i class="ti ti-eye toggle-balance" title="Hide/Show Balance"></i>
                            </div>
                        </div>

                        <!-- Actions -->
                        <div class="portfolio-actions mb-4">
                            <a href="{{ route('user.deposit.method') }}" class="btn btn-outline-primary">
                                Deposit
                            </a>
                            <a href="{{ route('user.withdraw.method') }}" class="btn btn-outline-secondary">
                                Withdraw
                            </a>
                            <a href="{{ route('user.trade.index') }}" class="btn btn-primary">
                                Trade
                            </a>
                        </div>

                        <!-- Metrics -->
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="metric-card profit">
                                    <span class="metric-label">Total Profit</span>
                                    <span class="metric-value text-success">
                                        +{{ currency($user->currency) . formatAmount($totalProfits) }}
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="metric-card">
                                    <span class="metric-label">Open Trades</span>
                                    <span class="metric-value">{{ $openTrades }}</span>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="metric-card">
                                    <span class="metric-label">Deposits</span>
                                    <span
                                        class="metric-value">{{ currency($user->currency) . formatAmount($totalDeposits) }}</span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </section>

            <!-- Portfolio End -->

            <!-- Signal -->
            @php
                $strength = $user->signal_strength; // 0-100
            @endphp

            <section class="col-lg-4 mb-4">
                <div class="card signal-card">
                    <div class="card-body">

                        <h6 class="mb-3">Signal Strength</h6>

                        <div class="signal-circle" style="--strength: {{ $strength }};">
                            <svg viewBox="0 0 36 36">
                                <circle cx="18" cy="18" r="16" fill="none" stroke="#1e293b"
                                    stroke-width="3" />
                                <circle cx="18" cy="18" r="16" fill="none" stroke="#22c55e"
                                    stroke-width="3" stroke-linecap="round"
                                    stroke-dasharray="calc(var(--strength) * 1),100" />
                            </svg>
                            <div class="signal-value">
                                {{ $strength }}%
                                <span>
                                    @if ($strength >= 70)
                                        Strong
                                    @elseif($strength >= 40)
                                        Moderate
                                    @else
                                        Weak
                                    @endif
                                </span>
                            </div>
                        </div>

                        <!-- Guidance -->
                        <p class="signal-note">
                            Signals above <strong>70%</strong> indicate favorable
                            market conditions with reduced risk.
                        </p>

                    </div>
                </div>
            </section>
            <!-- Signal End -->

            <!-- Trading View -->
            <section class="col-lg-8 mb-4">
                <div class="card chart-card" style="height: 520px;">
                    <div class="card-body p-0">

                        <div class="tradingview-widget-container h-100">
                            <div class="tradingview-widget-container__widget"></div>

                            <script src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
                                {
                                    "symbol": "BITSTAMP:BTCUSD",
                                    "interval": "D",
                                    "theme": "dark",
                                    "autosize": true,
                                    "locale": "en",
                                    "hide_side_toolbar": true,
                                    "allow_symbol_change": true
                                }
                            </script>
                        </div>

                    </div>
                </div>
            </section>
            <!-- Trading View End -->

            <!-- Trade -->
            <section class="col-lg-4 mb-4">
                <x-dashboard.card title="Trade">
                    @include('dashboard.user.partials.trade')
                </x-dashboard.card>
            </section>
            <!-- Trade End -->
        </div>

    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const toggle = document.querySelector('.toggle-balance');
            const balance = document.querySelector('.balance-value');

            toggle.addEventListener('click', function() {
                if (balance.textContent.trim() !== '••••••') {
                    // Hide balance
                    balance.dataset.original = balance.textContent.trim();
                    balance.textContent = '••••••';
                    toggle.classList.add('hidden');
                } else {
                    // Show balance
                    balance.textContent = balance.dataset.original;
                    toggle.classList.remove('hidden');
                }
            });
        });
    </script>
@endsection
