<form action="{{ route('user.profile.kyc') }}" method="POST" enctype="multipart/form-data">
    @csrf

    <!-- Country -->
    <div class="mb-3">
        <label for="country" class="form-label fw-semibold">Country</label>
        <select name="country" id="country" class="form-select @error('country') is-invalid @enderror">
            <option value="">-- Select Country --</option>
            @foreach (config('setting.countries') as $country)
                <option value="{{ $country }}" {{ old('country', $user->country) == $country ? 'selected' : '' }}>
                    {{ $country }}</option>
            @endforeach
        </select>
        @error('country')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <!-- Address -->
    <div class="mb-3">
        <label for="address" class="form-label fw-semibold">Address</label>
        <input type="text" name="address" id="address" value="{{ old('address', $user->address) }}"
            class="form-control @error('address') is-invalid @enderror" placeholder="Enter your address">
        @error('address')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <!-- City and State -->
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="city" class="form-label fw-semibold">City</label>
            <input type="text" name="city" id="city" value="{{ old('city', $user->city) }}"
                class="form-control @error('city') is-invalid @enderror" placeholder="Enter your city">
            @error('city')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-3">
            <label for="state" class="form-label fw-semibold">State</label>
            <input type="text" name="state" id="state" value="{{ old('state', $user->state) }}"
                class="form-control @error('state') is-invalid @enderror" placeholder="Enter your state">
            @error('state')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <!-- ZIP Code -->
    <div class="mb-3">
        <label for="zip_code" class="form-label fw-semibold">ZIP / Postal Code</label>
        <input type="text" name="zip_code" id="zip_code" value="{{ old('zip_code', $user->zip_code) }}"
            class="form-control @error('zip_code') is-invalid @enderror" placeholder="Enter ZIP code">
        @error('zip_code')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <!-- ID Type -->
    <div class="mb-3">
        <label for="id_type" class="form-label fw-semibold">Identification Type</label>
        <select name="id_type" id="id_type" class="form-select @error('id_type') is-invalid @enderror">
            <option value="">-- Select ID Type --</option>
            @foreach ($idTypes as $idType)
                <option value="{{ $idType->value }}" @if (old('id_type', $user->id_type->value ?? '') == $idType->value) selected @endif>
                    {{ $idType->label() }}
                </option>
            @endforeach
        </select>
        @error('id_type')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <!-- ID Uploads -->
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="id_front" class="form-label fw-semibold">Upload Front of ID</label>
            <input type="file" name="id_front" id="id_front"
                class="form-control @error('id_front') is-invalid @enderror">
            @error('id_front')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="col-md-6 mb-3">
            <label for="id_back" class="form-label fw-semibold">Upload Back of ID</label>
            <input type="file" name="id_back" id="id_back"
                class="form-control @error('id_back') is-invalid @enderror">
            @error('id_back')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <!-- Submit Button -->
    <div class="d-grid">
        <x-dashboard.submit-and-back-button href="{{ route('user.profile.index') }}" submit="Submit Verification"
            class="btn btn-primary" icon="bi bi-shield-check me-1" />
    </div>
</form>
