@extends('dashboard.user.layouts.app')

@section('content')
    <style>
        .plan-option {
            transition: all 0.25s ease;
        }

        .plan-option:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, .08);
        }

        .plan-badge {
            position: absolute;
            top: 15px;
            right: 15px;
        }
    </style>

    <div class="page-container">

        <!-- Page Header -->
        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <!-- Content -->

        <div class="row justify-content-center">
            <div class="col-lg-10 mt-3">

                <div class="text-center mb-4">
                    <h4 class="fw-semibold">Choose a Trading Plan</h4>
                    <p class="text-muted">
                        Select a plan that fits your capital, risk level, and daily trading goals.
                    </p>
                </div>

                <div class="row g-4">

                    @forelse ($plans as $plan)
                        <div class="col-lg-4 col-md-6">
                            <div class="card h-100 border-0 shadow-sm plan-option position-relative">

                                <!-- Plan Type -->
                                <span class="badge bg-primary plan-badge">
                                    {{ $plan->type->label() }}
                                </span>

                                <div class="card-body d-flex flex-column text-center">

                                    <!-- Icon -->
                                    <div class="mb-3">
                                        <i class="ti ti-trending-up fs-1 text-primary"></i>
                                    </div>

                                    <!-- Name -->
                                    <h5 class="fw-semibold mb-1">
                                        {{ $plan->name }}
                                    </h5>

                                    <!-- Daily Profit -->
                                    <h4 class="fw-bold text-dark mb-2">
                                        {{ $plan->daily_profit }}% Daily
                                    </h4>

                                    <!-- Trading Range -->
                                    <p class="text-muted small mb-3">
                                        Min: {{ currency($user->currency) }}{{ formatAmount($plan->minimum) }} |
                                        Max: {{ currency($user->currency) }}{{ formatAmount($plan->maximum) }}
                                    </p>

                                    <!-- Features -->
                                    <ul class="list-unstyled small text-muted mb-4">
                                        <li>
                                            <i class="ti ti-check text-success"></i>
                                            {{ $plan->trades_per_day }} trades per day
                                        </li>
                                        <li>
                                            <i class="ti ti-check text-success"></i>
                                            {{ $plan->daily_profit_duration }} days duration
                                        </li>
                                        @foreach (explode(',', $plan->features) as $feature)
                                            <li>
                                                <i class="ti ti-check text-success"></i>
                                                {{ $feature }}
                                            </li>
                                        @endforeach
                                    </ul>

                                    <!-- Action -->
                                    @php
                                        $userPlan = \App\Models\UserPlan::where('user_id', $user->id)->where(
                                            'plan_id',
                                            $plan->id,
                                        );
                                    @endphp
                                    @if (!$userPlan->exists())
                                        <div class="mt-auto">
                                            <a href="{{ route('user.plan.payment.method', $plan->uuid) }}"
                                                class="btn btn-primary w-100">
                                                Select Plan
                                            </a>
                                        </div>
                                    @else
                                        <div class="mt-auto">
                                            <button disabled class="btn btn-primary w-100">
                                                Selected
                                            </button>
                                        </div>
                                    @endif

                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-12">
                            <div class="alert alert-warning text-center">
                                No trading plans available at the moment.
                            </div>
                        </div>
                    @endforelse

                </div>

            </div>
        </div>

    </div>
@endsection
