@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-12">

                <div class="row justify-content-center">
                    <div class="col-lg-8 col-md-10">

                        <div class="mb-4">
                            <a href="{{ route('user.withdraw.method') }}" class="text-muted small">
                                ← Back to withdrawal methods
                            </a>
                        </div>

                        <div class="card shadow-sm border-0">
                            <div class="card-header border-bottom">
                                <h5 class="mb-1">Withdraw to Crypto Wallet</h5>
                                <small class="text-muted">
                                    Ensure the wallet address and network are correct.
                                </small>
                            </div>

                            <div class="card-body">
                                <form action="{{ route('user.withdraw.method.crypto.store') }}" method="POST">
                                    @csrf

                                    <div class="mb-3">
                                        <label class="form-label">Account Holder</label>
                                        <select name="user_id" class="form-select">
                                            <option value="{{ auth()->id() }}">
                                                {{ auth()->user()->name }}
                                            </option>
                                        </select>
                                    </div>

                                    <div class="row g-3 mb-3">
                                        <div class="col-md-6">
                                            <label class="form-label">Wallet (From)</label>
                                            <select name="wallet_id" class="form-select">
                                                @foreach ($wallets as $wallet)
                                                    <option value="{{ $wallet->id }}">
                                                        {{ strtoupper($wallet->name) }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">Amount</label>
                                            <input type="text" name="amount" class="form-control"
                                                placeholder="Enter amount">
                                        </div>
                                    </div>

                                    <div class="row g-3 mb-4">
                                        <div class="col-md-6">
                                            <label class="form-label">Wallet Address</label>
                                            <input type="text" name="address" class="form-control"
                                                placeholder="Recipient wallet address">
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">
                                                Network <span class="text-muted">(optional)</span>
                                            </label>
                                            <input type="text" name="network" class="form-control"
                                                placeholder="ERC20, TRC20, etc.">
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-end">
                                        <button class="btn btn-primary px-4">
                                            Proceed Withdrawal
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection
