@extends('auth.layouts.app')
@section('content')
    <div>
        <div class="auth-bg d-flex min-vh-100 justify-content-center align-items-center">
            <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
                <div class="col-xl-4 col-lg-5 col-md-6">
                    <div class="card overflow-hidden text-center h-100 p-xxl-4 p-3 mb-0">

                        {{-- Header / Logo --}}
                        @include('auth.layouts.header')

                        {{-- Title --}}
                        <h3 class="fw-semibold mb-3">
                            Welcome to {{ config('app.name') }}
                        </h3>

                        {{-- Description --}}
                        <p class="text-muted mb-4 fs-14">
                            {{ config('app.name') }} is designed to help you hold and manage capital efficiently through a
                            neutral
                            third-party automated trading system. Acting as your trustee, we oversee your funds and execute
                            trades in line with the system’s directives, while you receive the resulting profits.
                            <br><br>
                            All deposited capital is traded using our proprietary indicator, monitored by a team of
                            professional traders to achieve consistent and exceptional returns. Additionally, every
                            investor gains access to our decentralized automated trading platform, where you can track
                            daily activities, monitor performance, view earnings and bonuses, and take full advantage of
                            the system’s features.
                        </p>

                        {{-- CTA --}}
                        <div class="d-grid mb-4">
                            <a href="{{ route('login') }}" class="btn btn-primary btn-lg">
                                Get Started
                            </a>
                        </div>

                        <hr class="my-4">

                        {{-- Footer Info Section --}}
                        <livewire:frontend.newsletter-subscriber />

                        <hr class="my-4">

                        {{-- Copyright --}}
                        @include('auth.layouts.footer')
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
