<div class="table-responsive">
    <table class="table table-bordered align-middle">
        <tbody>
            <tr>
                <th scope="row" class="w-25">Transaction ID</th>
                <td><?php echo e($transaction->uuid); ?></td>
            </tr>
            <tr>
                <th scope="row" class="w-25">Transaction Reference</th>
                <td><?php echo e($transaction->reference_id); ?></td>
            </tr>

            <tr>
                <th>Type</th>
                <td><?php echo e($transaction->type->label()); ?></td>
            </tr>

            <tr>
                <th>Amount</th>
                <td>
                    <strong>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($transaction->isDirectionCredit()): ?>
                            <span class="text-success">
                                +<?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->amount)); ?>

                            </span>
                        <?php else: ?>
                            <span class="text-danger">
                                -<?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->amount)); ?>

                            </span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </strong>
                </td>
            </tr>

            <tr>
                <th>Description</th>
                <td><?php echo e($transaction->description ?? 'N/A'); ?></td>
            </tr>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($transaction->note): ?>
                <tr>
                    <th>Additional Note</th>
                    <td><?php echo e($transaction->note ?? 'N/A'); ?></td>
                </tr>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <tr>
                <th>Status</th>
                <td>
                    <span class="<?php echo e($transaction->status->badge()); ?>">
                        <?php echo e($transaction->status->label()); ?>

                    </span>
                </td>
            </tr>

            <tr>
                <th>Transaction Date</th>
                <td><?php echo e(formatDateTime($transaction->transaction_at)); ?></td>
            </tr>

        </tbody>
    </table>
</div>
<?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/components/dashboard/transaction-details.blade.php ENDPATH**/ ?>