<?php $__env->startSection('content'); ?>
    <style>
        .plan-option {
            transition: all 0.25s ease;
        }

        .plan-option:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, .08);
        }

        .plan-badge {
            position: absolute;
            top: 15px;
            right: 15px;
        }
    </style>

    <div class="page-container">

        <!-- Page Header -->
        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <!-- Content -->

        <div class="row justify-content-center">
            <div class="col-lg-10 mt-3">

                <div class="text-center mb-4">
                    <h4 class="fw-semibold">Choose a Trading Plan</h4>
                    <p class="text-muted">
                        Select a plan that fits your capital, risk level, and daily trading goals.
                    </p>
                </div>

                <div class="row g-4">

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="card h-100 border-0 shadow-sm plan-option position-relative">

                                <!-- Plan Type -->
                                <span class="badge bg-primary plan-badge">
                                    <?php echo e($plan->type->label()); ?>

                                </span>

                                <div class="card-body d-flex flex-column text-center">

                                    <!-- Icon -->
                                    <div class="mb-3">
                                        <i class="ti ti-trending-up fs-1 text-primary"></i>
                                    </div>

                                    <!-- Name -->
                                    <h5 class="fw-semibold mb-1">
                                        <?php echo e($plan->name); ?>

                                    </h5>

                                    <!-- Daily Profit -->
                                    <h4 class="fw-bold text-dark mb-2">
                                        <?php echo e($plan->daily_profit); ?>% Daily
                                    </h4>

                                    <!-- Trading Range -->
                                    <p class="text-muted small mb-3">
                                        Min: <?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($plan->minimum)); ?> |
                                        Max: <?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($plan->maximum)); ?>

                                    </p>

                                    <!-- Features -->
                                    <ul class="list-unstyled small text-muted mb-4">
                                        <li>
                                            <i class="ti ti-check text-success"></i>
                                            <?php echo e($plan->trades_per_day); ?> trades per day
                                        </li>
                                        <li>
                                            <i class="ti ti-check text-success"></i>
                                            <?php echo e($plan->daily_profit_duration); ?> days duration
                                        </li>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = explode(',', $plan->features); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                                            <li>
                                                <i class="ti ti-check text-success"></i>
                                                <?php echo e($feature); ?>

                                            </li>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                                    </ul>

                                    <!-- Action -->
                                    <?php
                                        $userPlan = \App\Models\UserPlan::where('user_id', $user->id)->where(
                                            'plan_id',
                                            $plan->id,
                                        );
                                    ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$userPlan->exists()): ?>
                                        <div class="mt-auto">
                                            <a href="<?php echo e(route('user.plan.payment.method', $plan->uuid)); ?>"
                                                class="btn btn-primary w-100">
                                                Select Plan
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="mt-auto">
                                            <button disabled class="btn btn-primary w-100">
                                                Selected
                                            </button>
                                        </div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                </div>
                            </div>
                        </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <div class="col-12">
                            <div class="alert alert-warning text-center">
                                No trading plans available at the moment.
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                </div>

            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/user/plan/index.blade.php ENDPATH**/ ?>