<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $attributes = $__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__attributesOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b)): ?>
<?php $component = $__componentOriginalc60db44e52d942d3b0e4d76f7065f04b; ?>
<?php unset($__componentOriginalc60db44e52d942d3b0e4d76f7065f04b); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-12 mt-4">

                <!-- Section Header -->
                <div class="mb-4">
                    <h3 class="fw-semibold mb-1">Traders</h3>
                    <p class="text-muted mb-0">
                        Link your trading account to an existing trader to get free access to their tools including signals
                        to earn maximum profits
                    </p>
                </div>

                <!-- Search Card -->
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <form action="<?php echo e(route('user.copy.trade.index')); ?>" method="GET">
                            <label for="traderSearch" class="form-label fw-medium">
                                Search Trader
                            </label>

                            <div class="input-group">
                                <input type="text" id="traderSearch" name="search" class="form-control"
                                    placeholder="Enter trader UUID" value="<?php echo e(request('search')); ?>" required>
                                <button class="btn btn-primary" type="submit">
                                    <i class="ti ti-search me-1"></i> Search
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Information Card -->
                <div class="card border-info shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title text-info fw-semibold mb-2">
                            What is Copy Trading?
                        </h5>

                        <p class="card-text text-muted mb-0">
                            Copy Trading is a type of trading where you directly copy the positions taken by another trader.
                            This way, you can utilize another trader's skills and knowledge to earn profits without having
                            to make any trading decisions yourself.
                        </p>
                    </div>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(request()->filled('search')): ?>
                    <div class="card mb-4 shadow-sm">
                        <div class="card-body">

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trader): ?>
                                <div class="d-flex align-items-center mb-3">
                                    <a href="<?php echo e(asset($trader->image)); ?>" target="_blank">
                                        <img src="<?php echo e(asset($trader->image)); ?>" alt="<?php echo e($trader->user->name); ?>"
                                            class="rounded-circle me-3" width="64" height="64">
                                    </a>

                                    <div>
                                        <h5 class="mb-0 fw-semibold"><?php echo e($trader->user->name); ?></h5>
                                        <small class="text-muted">UUID: <?php echo e($trader->uuid); ?></small>
                                    </div>
                                </div>

                                <div class="row text-center mb-3">
                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Balance</small>
                                            <span
                                                class="fw-semibold"><?php echo e(currency($trader->user->currency) . formatAMount($trader->balance)); ?></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Status</small>
                                            <span class="fw-semibold"><span
                                                    class="<?php echo e($trader->status->badge()); ?>"><?php echo e($trader->status->label()); ?></span></span>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="border rounded p-3 h-100">
                                            <small class="text-muted d-block">Experience</small>
                                            <span class="fw-semibold"><?php echo e($trader->experience->label()); ?>:
                                                <?php echo e($trader->notes); ?></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <form action="<?php echo e(route('user.copy.trade.link', $trader->uuid)); ?>" method="POST"
                                        onsubmit="return confirm('Are you sure you want to link this trader?')">
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-outline-success">
                                            Link
                                        </button>
                                    </form>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-4">
                                    <i class="fi fi-br-info text-muted fs-4 mb-2 d-block"></i>
                                    <p class="mb-0 text-muted">
                                        No trader found with the provided UUID.
                                    </p>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\broker-v6.0\resources\views/dashboard/user/copy_trade/index.blade.php ENDPATH**/ ?>